<?php
// --- Configuration ---
// DEFINE YOUR SECRET TOKEN AND API URL HERE
// This is the ONLY place your secret token will be.
define('TS_DOWNLOADER_API_TOKEN', 'Token dd6b5ac2a5a50f1dcd207c4fb2df33aaf4c2c915'); // Replace with your actual Token
define('TS_DOWNLOADER_API_URL', 'https://dev.bluebot.ir/api/generate/'); // Your API Address

// --- Security Headers ---
header('Content-Type: application/json');

// --- Helper function to get User IP (Cloudflare compatible) ---
function ts_downloader_get_user_ip() {
    $ip_keys = ['HTTP_CF_CONNECTING_IP', 'HTTP_X_REAL_IP', 'HTTP_X_FORWARDED_FOR', 'REMOTE_ADDR'];
    foreach ($ip_keys as $key) {
        if (array_key_exists($key, $_SERVER) === true && !empty($_SERVER[$key])) {
            $ips_list = explode(',', trim($_SERVER[$key]));
            $potential_ip = trim($ips_list[0]);
            if (filter_var($potential_ip, FILTER_VALIDATE_IP)) {
                return $potential_ip;
            }
        }
    }
    return '0.0.0.0';
}

// --- Main Logic ---

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['success' => false, 'data' => 'Method Not Allowed']);
    exit;
}

// Get the Telegram link from the POST request
$telegram_link = isset($_POST['telegram_link']) ? filter_var($_POST['telegram_link'], FILTER_SANITIZE_URL) : '';

if (empty($telegram_link) || filter_var($telegram_link, FILTER_VALIDATE_URL) === false) {
    http_response_code(400); // Bad Request
    echo json_encode(['success' => false, 'data' => ['api_status_code' => 400, 'data' => ['message' => 'Invalid or empty Telegram link provided.']]]);
    exit;
}

$user_ip = ts_downloader_get_user_ip();

$request_body = json_encode([
    'user_ip'       => $user_ip,
    'telegram_link' => $telegram_link
]);

// Use cURL to make the server-to-server request
$ch = curl_init(TS_DOWNLOADER_API_URL);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $request_body);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json',
    'Authorization: ' . TS_DOWNLOADER_API_TOKEN,
    'Content-Length: ' . strlen($request_body)
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response_body = curl_exec($ch);
$response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

// --- Handle Response ---

if ($curl_error) {
    http_response_code(503); // Service Unavailable
    echo json_encode(['success' => false, 'data' => ['api_status_code' => 503, 'data' => ['message' => 'Failed to connect to the download service.']]]);
    exit;
}

$response_data = json_decode($response_body, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(502); // Bad Gateway
    echo json_encode(['success' => false, 'data' => ['api_status_code' => 502, 'data' => ['message' => 'Received an invalid response from the download service.']]]);
    exit;
}

http_response_code($response_code);

if ($response_code >= 200 && $response_code < 300) {
    echo json_encode(['success' => true, 'data' => ['api_status_code' => $response_code, 'data' => $response_data]]);
} else {
    echo json_encode(['success' => false, 'data' => ['api_status_code' => $response_code, 'data' => $response_data]]);
}

?>

